/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.tile;

import azmalent.terraincognita.common.data.ModItemTags;
import azmalent.terraincognita.common.inventory.BasketContainer;
import azmalent.terraincognita.common.inventory.BasketStackHandler;
import azmalent.terraincognita.common.item.block.BasketItem;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModTileEntities;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BasketTileEntity
extends TileEntity
implements INamedContainerProvider,
ISidedInventory {
    private static final int[] SLOTS = IntStream.range(0, 9).toArray();
    private ITextComponent customName = null;
    private BasketStackHandler stackHandler = null;

    public BasketTileEntity() {
        super((TileEntityType)ModTileEntities.BASKET.get());
    }

    public void readFromStack(ItemStack stack) {
        this.stackHandler = new BasketStackHandler();
        if (stack.func_77973_b() == ModBlocks.BASKET.getItem()) {
            BasketStackHandler itemHandler = BasketItem.getStackHandler(stack);
            if (itemHandler != null) {
                for (int i = 0; i < 9; ++i) {
                    this.stackHandler.setStackInSlot(i, itemHandler.getStackInSlot(i).func_77946_l());
                }
            }
            if (stack.func_82837_s()) {
                this.setCustomName(stack.func_200301_q());
            }
        }
    }

    public ItemStack saveToStack() {
        ItemStack stack = ModBlocks.BASKET.makeStack();
        BasketStackHandler itemHandler = BasketItem.getStackHandler(stack);
        if (itemHandler != null) {
            itemHandler.setContents(this.stackHandler.getContents());
        }
        if (this.customName != null) {
            stack.func_200302_a(this.customName);
        }
        return stack;
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.stackHandler != null) {
            NonNullList itemList = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.stackHandler.getStackInSlot(i);
                itemList.set(i, (Object)stack);
            }
            ItemStackHelper.func_191281_a((CompoundNBT)tag, (NonNullList)itemList, (boolean)false);
        }
        if (this.customName != null) {
            if (!tag.func_150297_b("display", 10)) {
                tag.func_218657_a("display", (INBT)new CompoundNBT());
            }
            CompoundNBT display = tag.func_74775_l("display");
            display.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        CompoundNBT display;
        super.func_230337_a_(state, tag);
        this.stackHandler = new BasketStackHandler();
        if (tag.func_150297_b("Items", 9)) {
            NonNullList items = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)items);
            this.stackHandler.setContents((NonNullList<ItemStack>)items);
        }
        if (tag.func_150297_b("display", 10) && (display = tag.func_74775_l("display")).func_150297_b("Name", 8)) {
            String name = display.func_74779_i("Name");
            this.setCustomName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)name));
        }
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double MAXIMUM_DISTANCE_SQ = 64.0;
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.customName != null ? this.customName : new TranslationTextComponent(ModBlocks.BASKET.getBlock().func_149739_a());
    }

    @Nullable
    public Container createMenu(int i, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerEntity) {
        return new BasketContainer(i, playerInventory, this.stackHandler, this);
    }

    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
    }

    public int func_70302_i_() {
        return this.stackHandler.getSlots();
    }

    public boolean func_191420_l() {
        return this.stackHandler.isEmpty();
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        return this.stackHandler.getStackInSlot(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int amount) {
        return this.stackHandler.extractItem(i, amount, false);
    }

    @Nonnull
    public ItemStack func_70304_b(int i) {
        int limit = this.stackHandler.getSlotLimit(i);
        return this.stackHandler.extractItem(i, limit, false);
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemStack) {
        this.stackHandler.setStackInSlot(i, itemStack);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.stackHandler.getSlots(); ++i) {
            this.stackHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull Direction side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return itemStackIn.func_77973_b().func_206844_a(ModItemTags.BASKET_STORABLE);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return true;
    }
}

